<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function productCategory()
    {
        return $this->belongsTo('ProductCategory');
    }

    public function productKeys()
    {
        return $this->hasMany('ProductItem', 'product_id');
    }

    public function Image()
    {
        return $this->hasMany('ProductImage', 'product_id');
    }

}